using UnityEngine;
using System.Collections;

public class s_LevelSelect : MonoBehaviour 
{
	static public int buttonCount;
	static public int levelOffset = 1; //This is how many levels are in front of game levels in build settings
	static public int invalidLevel = 10;
	
	public GameObject buttonObject;
	public GameObject buttonForward;
	public GameObject buttonBack;
	
	//public string[] selStrings = new string[]{"Level 1", "Level 2", "Level 3", "Level 4", "Level 5", "Level 6"};
	//int selGridInt = -1;
	
	int gridMaxX = 4;
	int gridMaxY = 3;
	float gridOffsetX = 2.0f;
	float gridOffsetY = -1.5f;
	float gridNextPageOffsetX = 25.0f;
	
	public string currentAnimationName;
	public int currentPage = 0;
	int maxPage;
	
	void Start()
	{	
		buttonCount = 0;
		
		int currX = 1;
		int currY = 1;
		float currOffsetX = 1;
		
		maxPage = (Application.levelCount - levelOffset) / (gridMaxX * gridMaxY) - 1;
		
		//for(int i = 0; i < levels.Length; ++i)
		for(int i = 0; i < Application.levelCount - levelOffset; ++i)
		{
			//Create buttons
			GameObject currButton = (GameObject)Instantiate(buttonObject, transform.position, buttonObject.transform.rotation);
			currButton.transform.position = new Vector3(gridOffsetX * currX + currOffsetX, 0, gridOffsetY * currY);
			currButton.transform.parent = transform;
			
			//Change color if not clickable or first level
			if (PlayerPrefs.GetInt("Stars " + (i - 1)) == invalidLevel && i != 0) //0 is default, and so nothing is there
			{
				currButton.transform.Find("Lock").renderer.enabled = true;
				currButton.renderer.material.color = new Color(0.35f, 0.35f, 0.35f);
			}
			
			//Update position
			++currX;
			
			if (currX > gridMaxX)
			{
				currX = 1;
				++currY;
			}
			if (currY > gridMaxY)
			{
				currOffsetX += gridNextPageOffsetX;
				currY = 1;
				currX = 1;
			}
			
		}
		
		StartCoroutine(PositionBackground());
		UpdateMovementParent();
		UpdateMoveButtons();
	}
	
	IEnumerator PositionBackground()
	{
		yield return new WaitForEndOfFrame();
		//Move the background
		GameObject background = GameObject.Find("LevelSelectBackground");
		background.transform.position = new Vector3(background.transform.position.x, background.transform.position.y, 5.8f);
	}
	
	public void UpdateMovementParent()
	{
		transform.parent.transform.position = new Vector3(4f, 0.001f, 29.35f); //This is so I don't have to move the camera
		transform.position = transform.parent.transform.position;
		
		currentPage = 0;
	}
	
	public void UpdateMoveButtons()
	{
		if (currentPage < maxPage)
			ShowButton(buttonForward);
		else
			HideButton(buttonForward);
			
		if (currentPage > 0)
			ShowButton(buttonBack);
		else
			HideButton(buttonBack);
	}
	
	void HideButton(GameObject aButton)
	{
		aButton.renderer.enabled = false;
		aButton.collider.enabled = false;
	}
	
	void ShowButton(GameObject aButton)
	{
		aButton.renderer.enabled = true;
		aButton.collider.enabled = true;
	}
	
	IEnumerator MainMenu()
	{
		AudioManager.PlaySound(AudioManager.buttonNo);
		
		yield return new WaitForSeconds(AudioManager.buttonNo.length);
		
		Application.LoadLevel("MainMenu");
	}
	
	/*
	void Update()
	{
		//Gets input: click for osx, windows, and editor. Touch for android and iphone
#if UNITY_EDITOR || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX
		if (Input.GetMouseButtonDown(0))
#endif
					
#if UNITY_ANDROID && !UNITY_EDITOR || UNITY_IPHONE && !UNITY_EDITOR
		for (int i = 0; i < Input.touchCount; ++i)
            if (Input.GetTouch(i).phase.Equals(TouchPhase.Began))
#endif

				
			//Then makes a ray, for touch or click position
#if UNITY_ANDROID && !UNITY_EDITOR || UNITY_IPHONE && !UNITY_EDITOR
 			Ray ray = Camera.main.ScreenPointToRay(Input.GetTouch(i).position);
#endif
				
#if UNITY_EDITOR || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX
			Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
#endif
			
			RaycastHit hit;
			
			//Dont want to click anything if you already picked a level
			if (mLoading)
				return;
			
			//Animation Skip
			if (animation.isPlaying)
			{
				animation[currentAnimationName].time = 1;
				return;
			}
				
			//If you click on something
	  		if (Physics.Raycast(ray, out hit, 100.0f))
			{
				//All the buttons	
					
				//LevelSelectButtons
				if (hit.collider.gameObject.tag == "Button")
				{
					s_LevelSelectButton button = hit.collider.gameObject.GetComponent<s_LevelSelectButton>();
					if (button.Clicked())
						mLoading = true;
				}
				else if (hit.collider.gameObject.name == "ButtonLevelSelectMore")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
						
					transform.parent.transform.position = transform.position;			
					currentAnimationName = "LevelSelectCameraLeft";
					animation.Play(currentAnimationName);
					AudioManager.PlaySound(AudioManager.buttonYes);
					++currentPage;
				}
				else if (hit.collider.gameObject.name == "ButtonLevelSelectBack")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();	
					
					transform.parent.transform.position = transform.position;
					currentAnimationName = "LevelSelectCameraRight";
					animation.Play(currentAnimationName);
					AudioManager.PlaySound(AudioManager.buttonYes);
					--currentPage;
				}
				else if (hit.collider.gameObject.name == "ButtonLevelSelectMain")
				{
					StartCoroutine(MainMenu());
					mLoading = true;
				}
					
				UpdateMoveButtons();	
			}
		}
	}
	*/
	
	/*
	void OnGUI()
	{
		
		if (currentPage > 0)
		{
			if (GUI.Button(new Rect(40, Screen.height - 45, 80, 40), "Back"))
			{
				if (!animation.isPlaying)
				{
					transform.parent.transform.position = transform.position;
					currentAnimationName = "LevelSelectCameraRight";
					animation.Play(currentAnimationName);
					AudioManager.PlaySound(AudioManager.buttonYes);
					--currentPage;
				}
			}
		}
		
		if (currentPage < maxPage)
		{
			if (GUI.Button(new Rect(Screen.width - 120, Screen.height - 45, 80, 40), "More"))
			{
				if (!animation.isPlaying)
				{	
					transform.parent.transform.position = transform.position;			
					currentAnimationName = "LevelSelectCameraLeft";
					animation.Play(currentAnimationName);
					AudioManager.PlaySound(AudioManager.buttonYes);
					++currentPage;
				}
			}
		}
		
		
		 This is the old stuff!
		  
		//selGridInt = GUI.SelectionGrid (new Rect(50, 50, Screen.width - 100, Screen.height - 100), selGridInt, selStrings, 3);
		selGridInt = GUI.SelectionGrid (new Rect(50, 50, Screen.width - 100, Screen.height - 100), selGridInt, levels, 3);
		if(selGridInt != -1)
			Application.LoadLevel(selGridInt + levelOffset);
		
	}
	*/
}